package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Role;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.PersnWrapper;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.ctssh.ServiceFacade;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;



public class ServicePerson extends PersnWrapper {
	
	private static final long serialVersionUID = -8375561258486068131L;

	private boolean mviEnabled = Toolbox.isMviEnabled();
	private Role role = null;
	private boolean canSearch;
	private Persn caller = null;
	private String ssn = null;
	

	public ServicePerson ( PortletRequest request, Persn target ) throws Exception{
		super( target );
		if ( mviEnabled ) {
			caller = new PersnWrapper( PersnLocalServiceUtil.getByUser( PortalUtil.getUserId(request) ) ){
				public long getUserId() {
					return super.getUserId() ==  0 ? getPersnUserId() : super.getUserId();
				}
			};
		}
	}

	public List<Persn> doAttended () {
		List<Persn> persnList = Collections.EMPTY_LIST;
		
		canSearch = !( Toolbox.isEmpty( getLastName() ) && Toolbox.isEmpty( getFirstName() ) ); 
		if ( canSearch ){
			try {
						persnList =	translate( ServiceFacade.MVIAttendedSearch(caller, 
						getBirthDateStr(), getSsn(), getGender(),
						getFirstName(), getLastName(),
						null, null, null, null,
						null, null, null, null,
						null, null, null, null
//						getMiddleName(), getPrefix(), getSuffix(), getPhoneStr(),
//						getAddress(), getAddress2(), null, null, // address3, address4
//						getCity(), getState(), getZip(), getCountry()
						) );
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		_log.info("AttendedSearch not found");
		return persnList;
	}
	
	private List<Persn> translate( List alReturnResultp ) {
		List<Persn> persnList = new ArrayList<Persn> ();
		if ( alReturnResultp != null ){
			List<Map<String,String>> alReturnResults = (List<Map<String,String>>) alReturnResultp;
			for ( Map<String,String> rez: alReturnResults ){
				Person p = new Person ( new PersnImpl(){
					public void setAddress( String address ){
						String oldAddress = getAddress();
						if ( address!= null && !address.equals( oldAddress ) && !Toolbox.isEmpty( address ) ){
							String[] addrArray = address.split(StringPool.SPACE);
							StringBuilder sb = new StringBuilder();
							for ( String addr : addrArray ){
								sb.append(formatLabel(addr)).append(StringPool.SPACE);
							}
							address = sb.toString().trim();
						}
						super.setAddress(address);
					}
				});
				p.setFirstName(formatLabel(rez.get("FIRST_NAME")));
				p.setLastName(formatLabel(rez.get("LAST_NAME")));
				p.setMiddleName(formatLabel(rez.get("MIDDLE_NAME")));
				p.setPrefix(formatLabel(rez.get("PREFIX")));
				p.setSuffix(formatLabel(rez.get("SUFFIX")));
				p.setAddress(rez.get("STREET1"));
				if ( !Toolbox.isEmpty( rez.get("DOB") )){
					p.setBirthDate( Toolbox.parseOrientDate( rez.get("DOB") ) );
				}
				p.setCity(formatLabel(rez.get("CITY")));
				p.setState(rez.get("STATE"));
				p.setCountry(rez.get("COUNTRY"));
				p.setZip(rez.get("POSTALCODE"));
				p.setGender(rez.get("GENDER"));
				p.setICN(rez.get("ICN"));
				if ( !Toolbox.isEmpty( rez.get("SSN") ) ){
					p.setSsn( Toolbox.formatSsn( rez.get("SSN") ) );
				}
				persnList.add(p);
			}
		}
		return persnList;
	}
	
	private String formatLabel ( String orig ){
		if ( Toolbox.isEmpty(orig) ){
			return null;
		}
		return StringUtil.upperCaseFirstLetter(orig.toLowerCase());
	}

	public JSONObject doUnattended ()  {
		JSONObject vcg = JSONFactoryUtil.createJSONObject();
		
		canSearch = !( Toolbox.isEmpty( getLastName() ) && Toolbox.isEmpty( getFirstName() ) ); 
		if ( canSearch ){
			try {
				Map rez = ServiceFacade.MVIUnattendedSearch(caller, 
						getBirthDateStr(), getSsn(), getGender(),
						getFirstName(), getLastName(),
						null, null, null, null,
						null, null, null, null,
						null, null, null, null );
//						getMiddleName(), getPrefix(), getSuffix(), getPhoneStr(),
//						getAddress(), getAddress2(), null, null, // address3, address4
//						getCity(), getState(), getZip(), getCountry()
				
				List<Persn> result = translate( Collections.singletonList( (Map<String, String>)rez ) );
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		_log.info("UnattendedSearch not found");
		return vcg;
	}
	
	public String doEESearchHTML ()  {
//		canSearch = !( Toolbox.isEmpty( getIcn() ) ); 
//		if ( canSearch ){
			try {
				String tempIcn = getICN();

				if ( Toolbox.isEmpty( tempIcn ) ){
					Map<String, Object> rez = ServiceFacade.MVIUnattendedSearch(caller, 
							getBirthDateStr(), getSsn(), getGender(),
							getFirstName(), getLastName(),
							null, null, null, null,
							null, null, null, null,
							null, null, null, null
//							getMiddleName(), getPrefix(), getSuffix(), getPhoneStr(),
//							getAddress(), getAddress2(), null, null, // address3, address4
//							getCity(), getState(), getZip(), getCountry()
							);
					if ( rez != null ){
						List<Persn> l = translate( Collections.singletonList( rez ) );
						if ( !l.isEmpty() ){
							tempIcn = l.get(0).getICN();
						}
					}
					
				}
				if ( Toolbox.isEmpty( tempIcn ) ){
					_log.warn("USING DUMMY ICN");
					tempIcn = "0000001004841459V247268000000";
				}
				if ( tempIcn.length() == 17 ){
					_log.info("bootstrapping ICN format");
					tempIcn = "000000" + tempIcn + "000000";
				}
				return ServiceFacade.EESearchHTML( caller, tempIcn );
			} catch (Exception e) {
				e.printStackTrace();
			}
//		}
		_log.info("EESearchHTML not found");
		return null;
	}
	
	public void setModelAttributes(Map<String, Object> attributes) {
		
		setFirstName((String)attributes.get(CaretStrPool.FIRSTNAME));
		setLastName((String)attributes.get(CaretStrPool.LASTNAME));
		setMiddleName((String)attributes.get("middleName"));
		setGender((String)attributes.get(CaretStrPool.GENDER));
		setSsn((String)attributes.get(CaretStrPool.SSN));
		Object dateObj = attributes.get(CaretStrPool.BIRTHDATE);
		if ( dateObj != null ){
			setBirthDate( Toolbox.parseDate( dateObj.toString() ) );
		}
		setAddress((String)attributes.get(CaretStrPool.ADDRESS));
		setPhone((String)attributes.get("phone"));
		 
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = new HashMap<String, Object>(){
			public Object get( Object key ){
				if ( "doAttended".equals(key) ){
					return doAttended();
				}
				if ( "doUnattended".equals(key) ){
					return doUnattended();
				}
				if ( "doEESearchHTML".equals(key) ){
					return doEESearchHTML();
				}
				return super.get(key);
			}
		};
		
		return modelAttributes;
	}
	
	public String getBirthDateStr() {
		return getBirthDate() == null ? null: Toolbox.formatDateOrient( getBirthDate() );
	}
	
	public String getGender() {
		if ( !Toolbox.isEmpty( super.getGender() ) ){
			return super.getGender().substring(0,1).toUpperCase();
		}
		return null;
	}
	
	public String getPhoneStr() {
		if ( !Toolbox.isEmpty( getPhone() ) ){
			 return getPhone().replace("(", StringPool.BLANK).replace(") ", StringPool.BLANK).replace(StringPool.DASH, StringPool.BLANK);
		}
		return null;
	}
	
	public boolean isForeigner() {
		return !CaretStrPool.UNITED_STATES.equals(getCountry()) && !( StringPool.FALSE.equals( getCountry() ) || StringPool.BLANK.equals( getCountry() ) );
	}
	
	public String getCountry(){
		return null;
//		return isForeigner()? null: super.getCountry();
	}
	
	public String getSsn(){
		return ssn;
	}
	
	public String setSsn( String ssnIn ){
		return this.ssn = Toolbox.isEmpty(ssnIn)? null: ssnIn.replace(StringPool.DASH, StringPool.BLANK);
	}
	
	public void setPhone( String phone ){
		if ( Person.PHONE_FORMAT.equals( phone ) ){
			phone = StringPool.BLANK;
		}
		super.setPhone(phone);
	}
	
	public void setGender( String gender ){
		if ( !Toolbox.isEmpty(gender) ){
			if ( gender.length() == 1 ){
				if ( "M".equals(gender.toUpperCase()) ){
					super.setGender(CaretStrPool.GENDER_TYPE_MALE);
				} else if ( "F".equals(gender.toUpperCase()) ){
					super.setGender(CaretStrPool.GENDER_TYPE_FEMALE);
				}
			} else {
				super.setGender(gender);
			}
		} else {
			super.setGender(null);
		}
	}
	
	protected String getValue ( ResourceRequest request, String parameter ){
		String[] val = request.getParameterMap().get( parameter ); 
		return val==null? null: val[0] ;
	}
	
//	private Map<String, String> getMviMap(ResourceRequest request) {
//		
//		String fname = ParamUtil.get(request, CaretStrPool.FIRSTNAME, StringPool.BLANK);
//		 String lname = ParamUtil.get(request, CaretStrPool.LASTNAME, StringPool.BLANK);
//		 
//		 String ssn = getValue(request, CaretStrPool.SSN);
//		 if ( !Toolbox.isEmpty(ssn) ){
//			 ssn = ssn.replace(StringPool.DASH, StringPool.BLANK);
//		 }
//		 
//		 String birthdate = getValue(request, CaretStrPool.BIRTHDATE );
//		 if (  !Toolbox.isEmpty(birthdate) ){
//			 birthdate = Toolbox.formatDateOrient( Toolbox.parseDate(birthdate) );
//		 }
//		
//		 Map<String,String> map = new HashMap<String,String>();
//		 
//		 map.put(CTSSHConstants.FLD_MVI_LASTNAME, lname );
//		 map.put(CTSSHConstants.FLD_MVI_FIRSTNAME, fname );
//		 map.put(CTSSHConstants.FLD_MVI_DOB, birthdate );
//		 map.put(CTSSHConstants.FLD_MVI_SSN, ssn );
//		 map.put(CTSSHConstants.FLD_MVI_MIDDLENAME, getValue(request, "middleName" ) );
//		 map.put(CTSSHConstants.FLD_MVI_SUFFIX, getValue(request, "suffix") );
//		 map.put(CTSSHConstants.FLD_MVI_PATIENT_TELEPHONE, getValue(request, "phone" ) );
//		 map.put(CTSSHConstants.FLD_MVI_STREETADDRESS1, getValue(request, CaretStrPool.ADDRESS ) );
//		 map.put(CTSSHConstants.FLD_MVI_CITY, getValue(request, CaretStrPool.CITY) );
//		 map.put(CTSSHConstants.FLD_MVI_POSTALCODE, getValue(request, CaretStrPool.ZIP) );
//		 map.put(CTSSHConstants.FLD_MVI_STATE, getValue(request, CaretStrPool.STATE) );
//		 map.put(CTSSHConstants.FLD_MVI_GENDER, getValue(request, CaretStrPool.GENDER ) );
//		return map;
//	}
//	

	public void persist () throws SystemException{
		ApplicationWorkFlowException.handleException("IMPLEMENTATION DOESNT SUPPORT PERSISTENCE");
	}
	
	public long getRootPersnId() throws ApplicationWorkFlowException{
		return getPersnUserId() ==  0 ? PersnLocalServiceUtil.getByUser( getUserId() ).getPersnId() : getPersnId();
	}
	
	public long getUserId() {
		return super.getUserId() ==  0 ? getPersnUserId() : super.getUserId();
	}
	
	protected void setRole ( Role role ){
		this.role = role;
	}
	
	public Role getRole (){
		return role;
	}
	
	public String getIcn() {
		return Toolbox.nullSafe( getExternalId() );
	}
	
	public boolean isRegisteredIdentity (){
		return getPersnUserId() > 0 || ! Toolbox.isEmpty( getIcn() ); 
	}

	
	protected static Log _log = LogFactoryUtil.getLog( ServicePerson.class );

}
